/*
 * Copyright European Commission's
 * Taxation and Customs Union Directorate-General (DG TAXUD).
 */
package eu.europa.ec.taxud.cesop.domain;

import lombok.EqualsAndHashCode;
import lombok.Getter;

/**
 * Represents an XML value with its type and country attributes.
 */
@Getter
@EqualsAndHashCode(callSuper = true)
public class XmlCountryTypeAndValue extends XmlTypeAndValue {

    private final String country;

    public XmlCountryTypeAndValue(String country, String type, String value, String other) {
        super(type, value, other);
        this.country = country;
    }
}
